/**
* INTEL CONFIDENTIAL
* Copyright 2013-2014 Intel Corporation All Rights Reserved.

* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its suppliers
* and licensors. The Material may contain trade secrets and proprietary and confidential
* information of Intel Corporation and its suppliers and licensors, and is protected
* by worldwide copyright and trade secret laws and treaty provisions. No part of
* the Material may be used, copied, reproduced, modified, published, uploaded, posted,
* transmitted, distributed, or disclosed in any way without Intel's prior express
* written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual property
* right is granted to or conferred upon you by disclosure or delivery of the Materials,
* either expressly, by implication, inducement, estoppel or otherwise. Any license under
* such intellectual property rights must be express and approved by Intel in writing.
*
* Unless otherwise agreed by Intel in writing, you may not remove or alter this notice
* or any other notice embedded in Materials by Intel or Intel's suppliers or licensors in any way.
*/

#ifndef GPIOPUBLIC_H
#define GPIOPUBLIC_H

/* Define an Interface Guid so that app can find the device and talk to it. */
/* {e15fc621-0918-406c-911e-e43b7d4ce4e7} */
DEFINE_GUID (GUID_DEVINTERFACE_GPIO,
    0xe15fc621,0x0918,0x406c,0x91,0x1e,0xe4,0x3b,0x7d,0x4c,0xe4,0xe7);

/* Device type           -- in the "User Defined" range." */

#define GPIO_IOCTL_TYPE 0x8000

/* The IOCTL function codes from 0x800 to 0xFFF are for customer use. */

#define IOCTL_GPIO_READ \
    CTL_CODE( GPIO_IOCTL_TYPE, 0x900, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_GPIO_WRITE \
    CTL_CODE( GPIO_IOCTL_TYPE, 0x901, METHOD_OUT_DIRECT , FILE_ANY_ACCESS)

#define IOCTL_GPIO_DIRECTION \
    CTL_CODE( GPIO_IOCTL_TYPE, 0x902, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)

#define IOCTL_GPIO_MUX \
    CTL_CODE( GPIO_IOCTL_TYPE, 0x903, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)

#define IOCTL_GPIO_QUERY \
    CTL_CODE( GPIO_IOCTL_TYPE, 0x904, METHOD_BUFFERED, FILE_ANY_ACCESS)


typedef enum
{
    CONNECT_MODE_INVALID = 0,
    CONNECT_MODE_INPUT,
    CONNECT_MODE_OUTPUT,
    CONNECT_MODE_MAXIMUM  = CONNECT_MODE_OUTPUT
} GPIO_CONNECT_IO_PINS_MODE;


typedef enum 
{
    IRQ_TYPE_NONE           = 0x00000000,
    IRQ_TYPE_EDGE_RISING    = 0x00000001,
    IRQ_TYPE_EDGE_FALLING   = 0x00000002,
    IRQ_TYPE_EDGE_BOTH      = (IRQ_TYPE_EDGE_FALLING | IRQ_TYPE_EDGE_RISING),
    IRQ_TYPE_LEVEL_HIGH     = 0x00000004,
    IRQ_TYPE_LEVEL_LOW      = 0x00000008,
} GPIO_IRQ_TYPE;


typedef struct
{
    ULONG pin;
    union
    {
        ULONG data;
        GPIO_CONNECT_IO_PINS_MODE ConnectMode;
    } u;
} GPIO_PIN_PARAMETERS, *PGPIO_PIN_PARAMETERS;


#endif /* GPIOPUBLIC_H */
